<?php 
/*
Plugin Name: UBD Block Ad Plugin
Plugin URI: http://www.uniqueblogdesigns.com/blog/ubd-block-ad-plugin
Description: Let the blog owner add 125x125 block ads to their sidebar. <a href="options-general.php?page=ubd-block-ad.php">Set your Block Ads here.</a>.  Questions on configuration, etc.? Make sure to read the README.
Version: 1.1
Author: Unique Blog Designs
Author URI: http://www.uniqueblogdesigns.com
*/

//Check the currently installed version of wordpress
define('CFAC_WP_GTE_25', version_compare($wp_version, '2.5', '>='));

define('CFAC_NUM_CODES', 10);

if (!function_exists('wp_prototype_before_jquery')) {
	function wp_prototype_before_jquery( $js_array ) {
		if ( false === $jquery = array_search( 'jquery', $js_array ) )
			return $js_array;
		if ( false === $prototype = array_search( 'prototype', $js_array ) )
			return $js_array;
		if ( $prototype < $jquery )
			return $js_array;
		unset($js_array[$prototype]);
		array_splice( $js_array, $jquery, 0, 'prototype' );
		return $js_array;
	}
    add_filter( 'print_scripts_array', 'wp_prototype_before_jquery' );
}

function widget_cfac_init() {

	if ( !function_exists('register_sidebar_widget') )
		return;
		
	function widget_cfac($args) {
		    extract($args);
		
		echo $before_widget;
		echo( $before_title . $after_title );
		affiliate_code_link();
		echo( $after_widget );
} 

	
	register_sidebar_widget(array('Affiliates', 'widgets'), 'widget_cfac');
}
add_action('widgets_init', 'widget_cfac_init');

function cfac_get_code() {
	
	$affcode = maybe_unserialize(get_option('cfac_affcode'));
	$affcode_options = maybe_unserialize(get_option('cfac_options'));
	
	$show_count = $affcode_options[0];
	$column_count = $affcode_options[1];
	
	is_array($affcode) ? $count = count($affcode) : $count = 0;
	$random = rand(0,$count);
	$codes = array();
	$show = $random+$show_count;
	
	$current = $random;
	$oddeven = 1;
	
	if($show_count == '') {
		$show_count = 1;
		$show_gone = true;
	}
	if($column_count == '') {
		$column_count = 2;
		$column_gone = true;
	}
	
	for ($i = 0; $i < $show_count; $i++ ) {
		if ($current > $count - 1) {
			$current = 0;
		}

		$divcode = '<li>';

		$codes[$current] = $divcode.$affcode[$current].'</li>';

		$current++;
		$oddeven++;
	}
	
	if($show_gone || $column_gone) {
		$set_options = array($show_count, $column_count);
		
		update_option('cfac_options', serialize($set_options));
	}
	
	
	return $codes;
}

function affiliate_code_link() {

	$codes = cfac_get_code();
	$affcode_options = maybe_unserialize(get_option('cfac_options'));
	
	$column_count = $affcode_options[1];

	print('<ul class="ubd-block-ad">');
	
	foreach($codes as $code) {
		echo $code;
	}
	print('</ul>');
}

function cfac_jQuery() {
?>
<script type="text/javascript">
	jQuery(document).ready(function() {

	});
</script>
<?
}
// Checks to see if the browser is Internet explorer of any sort.
// IE doesn't do well with the quickly updating jQuery
if (!strstr($_SERVER["HTTP_USER_AGENT"], 'MSIE')) {
	add_action('admin_head', 'cfac_jQuery');
}

function cfac_admin_head_js() {
?>
<script type="text/javascript">
	function cfacAffCodeHandler() {
		jQuery('#cfac_form_code textarea.code').unbind().focus(function(){
			var id = jQuery(this).attr('id').replace('cfac_affiliate_code_', '');
			var textarea = this;
			interval = setInterval(function(){
				jQuery("#cfac_preview_" + id).html(jQuery(textarea).val());
			},500);
		}).blur(function(){  
			clearInterval(interval);
		});
		jQuery('#cfac_form_code input.remove').click(function() {
			var id = jQuery(this).attr('id').replace('cfac_remove_', '');
			jQuery('#code_' + id).remove();
			return false;
		});
	}
	jQuery(document).ready(function() {
		var interval;
		
		cfacAffCodeHandler();
	
<?php
if(CFAC_WP_GTE_25) {
	cfac_jQuery_25();
}
else {
	cfac_jQuery_pre_25();
}
?>
	});
</script>
<?

}
add_action('admin_head', 'cfac_admin_head_js');


function cfac_jQuery_25() {
?>
		jQuery('#cfac_add_code').click(function() {
			var html = '<tr valign="top" id="code_sec_###SECTION###"><th scope="row" width="20%"><p>Paste your code in this space to show up on your site.</p></th><td><p><textarea cols="60" rows="10" class="code" style="float:left;" name="cfac_affiliate_code[]" id="cfac_affiliate_code_sec_###SECTION###" style="font-size: 12px;"></textarea></p></td><td width="10%"><p align="center">Preview</p><p id="cfac_preview_sec_###SECTION###" style="float:right;" width="15%"></p></td><td width="2%" style="vertical-align: middle"><input type="button" id="cfac_remove_sec_###SECTION###" name="remove_sec_###SECTION###" value="Remove" class="remove" /></td></tr>';
			var id = new Date().valueOf();
			html = html.replace(/###SECTION###/g, id.toString());
			jQuery('#cfac_form_code tbody').append(html);
			cfacAffCodeHandler();
		});
<?
}

function cfac_jQuery_pre_25() {
?>
		jQuery('#cfac_add_code').click(function() {
			var html = '<fieldset class="options" id="code_###SECTION###"><p>Paste your code in this space to show up in the sidebar on your site.</p><p><textarea cols="60" rows="5" class="code" name="cfac_affiliate_code[]" id="cfac_affiliate_code_###SECTION###" style="width: 60%; font-size: 12px;"></textarea><span id="cfac_preview_###SECTION###"></span><span><input type="button" id="cfac_remove_###SECTION###" name="remove_###SECTION###" value="Remove" class="remove" /></span></p></fieldset>';
			var id = new Date().valueOf();
			html = html.replace(/###SECTION###/g, id.toString());
			jQuery('#cfac_form_code').append(html);
			cfacAffCodeHandler();
		});
<?
}

function cfac_request_handler() {

	if(isset($_POST['cfac_action']) && $_POST['cfac_action'] == 'update_settings') {

		if(current_user_can('manage_options')) {
			
			$store = array();
			
			foreach ($_POST['cfac_affiliate_code'] as $code => $val) {
				if(!empty($val)) {
					$store[$code] = stripslashes($val);
				}
			}
			
			update_option('cfac_affcode', serialize($store));
			if(isset($_POST['cfac_show_count']) && isset($_POST['cfac_column_count'])) {
				$cfac_options_array = array($_POST['cfac_show_count'],$_POST['cfac_column_count']);
				$cfac_options = serialize($cfac_options_array);
				update_option('cfac_options', $cfac_options);
			}

			header('Location: '.get_bloginfo('wpurl').'/wp-admin/options-general.php?page=ubd-block-ad.php&updated=true');
		}
		else {
			wp_die('You are not allowed to manage options.');
		}
	}

}
add_action('init', 'cfac_request_handler');

function cfac_menu_items() {
	if (current_user_can('manage_options')) {
		add_options_page(
			'Affiliate Options'
			, 'UBD Block Ad Settings'
			, 10
			, basename(__FILE__)
			, 'cfac_options_form'
		);
	}
	
	// Checks to see if the options are actually set, and if they are not sets them
	// Just for redundancy's sake
	$code_options = maybe_unserialize(get_option('cfac_options'));
	
	if($code_options[0] == '' && $code_options[1] == '') {
		$set_options = array('1','1');
		
		update_option('cfac_options', serialize($set_options));
	}	
}
add_action('admin_menu', 'cfac_menu_items');

function cfac_options_form() {
	
	$codearray = maybe_unserialize(get_option('cfac_affcode'));
	$code_options = maybe_unserialize(get_option('cfac_options'));

	is_array($codearray) ? $code_count = count($codearray) : $code_count = 0;
	
	$code_show = $code_options[0];
	$code_column = $code_options[1];
	
	if(CFAC_WP_GTE_25) {
		
		print('
			<div class="wrap">
				<h2>UBD Block Ad Settings</h2>
				<div id="cfac_form_code">
					<form action="'.get_bloginfo('wpurl').'/wp-admin/options-general.php" method="post">
						<table class="form-table">
							<tbody>
								<tr>
									<th scope="row">
										How many ads would you like to show?
									</th>
									<td colspan="3">
										<select name="cfac_show_count">');
										for($i = 1; $i <= CFAC_NUM_CODES; $i++) {
											if($code_show == $i) {
												$selected = ' selected="selected"';
											}
											else {
												$selected = '';
											}
											print('
											<option value="'.$i.'"'.$selected.'>'.$i.'</option>
											');
										}
										print('
										</select>
									</td>
								</tr>
								<tr>
									<th scope="row">
										How many columns would you like to have?
									</th>
									<td colspan="3">
										<select name="cfac_column_count">');
											if($code_column == "1") {
												print('
													<option value="1" selected="selected">1</option>
													<option value="2">2</option>
												');
											}
											else {
												print('
													<option value="1">1</option>
													<option value="2" selected="selected">2</option>
												');											
											}
										print('
										</select>									
									</td>
								</tr>
							');
								$i = 1;
								if($code_count == 0) {
									$codearray = array('');
								}
								foreach ($codearray as $code) {
									$section = 'sec_'.$i;
									print('
										<tr valign="top" id="code_'.$section.'">
											<th scope="row" width="20%">
												<p>
													Paste your code in this space to show up on your site.
												</p>
											</th>
											<td>
												<p>
													<textarea cols="60" rows="10" class="code" style="float:left;" name="cfac_affiliate_code[]" id="cfac_affiliate_code_'.$section.'" style="font-size: 12px;">'.htmlspecialchars($code).'</textarea>
												</p>
											</td>
											<td width="10%">
												<p align="center">
													Preview
												</p>
												<p id="cfac_preview_'.$section.'" style="float:right;" width="15%">
													'.stripslashes($code).'
												</p>
											</td>
											<td width="2%" style="vertical-align: middle">
												<input type="button" id="cfac_remove_'.$section.'" name="remove_'.$section.'" value="Remove" class="remove" />
											</td>
										</tr>
									');
									$i++;
								}
								print('
							</tbody>
						</table>
						<p class="submit">
							<input type="button" name="addcod" id="cfac_add_code" value="Add New Code" />						
						</p>
						<p class="submit" style="border-top: none;">
							<input type="hidden" name="cfac_action" value="update_settings" />
							<input type="submit" name="submit" value="Update Affiliate Code" />
						</p>
					</form>
				</div>
			</div>
		');
	}
	else {
	
		print('
			<div class="wrap">
				<h2>Affiliate Code Options</h2>
				<form action="'.get_bloginfo('wpurl').'/wp-admin/options-general.php?page=ubd-block-ad.php" method="post">
					<p class="submit">
						<input type="submit" name="submit" value="Update Affiliate Code" />
					</p>
					<div id="cfac_form_code">
						<fieldset class="options">
							<p>
								How many ads would you like to show?
							</p>
							<p>
								<select name="cfac_show_count">');
								for($i = 1; $i <= CFAC_NUM_CODES; $i++) {
									if($code_show == $i) {
										$selected = ' selected="selected"';
									}
									else {
										$selected = '';
									}
									print('
									<option value="'.$i.'"'.$selected.'>'.$i.'</option>
									');
								}
								print('</select>
							</p>
						</fieldset>
						<fieldset class="options">
							<p>
								How many columns would you like to show?
							</p>
							<p>
								<select name="cfac_column_count">');
									if($code_column == "1") {
										print('
											<option value="1" selected="selected">1</option>
											<option value="2">2</option>
										');
									}
									else {
										print('
											<option value="1">1</option>
											<option value="2" selected="selected">2</option>
										');											
									}
								print('
								</select>																
							</p>
						</fieldset>
						');
						$i = 1;
						if($code_count == 0) {
							$codearray = array('');
						}
						foreach($codearray as $code) {
							$section = 'sec_'.$i;
							print('
								<fieldset class="options" id="code_'.$section.'">
									<p>
										Paste your code in this space to show up in the sidebar on your site.
									</p>
									<p>
										<textarea cols="40" rows="5" class="code" name="cfac_affiliate_code[]" id="cfac_affiliate_code_'.$section.'" style="width: 60%; font-size: 12px;">'.htmlspecialchars($code).'</textarea>
										<span id="cfac_preview_'.$section.'">
											'.stripslashes($code).'
										</span>
										<span>
											<input type="button" id="cfac_remove_'.$section.'" name="remove_'.$section.'" value="Remove" class="remove" />
										</span>
									</p>					
								</fieldset>
							');
							$i++;
						}
					print('
					</div>
					<p>
						<input type="button" name="addcod" id="cfac_add_code" value="Add New Block Ad" />
					</p>
					<p class="submit">
						<input type="hidden" name="cfac_action" value="update_settings" />
						<input type="submit" name="submit" value="Update Block Ads" />
					</p>
				</form>
			</div>
		');
	}
}

?>